import numpy as np 
import os
import pdb
import matplotlib.pyplot as plt 
import pickle
from os.path import exists
from openpyxl import Workbook
from openpyxl import load_workbook
from sklearn.cluster import KMeans
from scipy.stats import chi2, norm, kendalltau, sem
from statsmodels.stats.proportion import proportion_confint
from sklearn import metrics
from random import randint
import sys
sys.path.append(os.getcwd() + "/ClassifierTwoSample/")
from ClassifierTwoSampleStats import *

def SetPltProp(ax, xn = None, yn=None, title=None, grid = True, bbox_to_anchor=None, legend = True, framealpha=1, ncol=1, pos = 'upper left', borderpad=None):
	fontsize = 14
	for axis in ['top','bottom','left','right']:
		ax.spines[axis].set_linewidth(2.5)

	for tick in ax.xaxis.get_major_ticks():
	    tick.label1.set_fontsize(fontsize)
	    tick.label1.set_fontweight('bold')
	for tick in ax.yaxis.get_major_ticks():
	    tick.label1.set_fontsize(fontsize)
	    tick.label1.set_fontweight('bold') 

	if legend:  
		if bbox_to_anchor == None: 
			ax.legend(loc=pos, shadow=True, ncol=ncol, prop={'weight':'bold', 'size':10},  framealpha=framealpha, borderpad=borderpad)
		else:
			ax.legend(shadow=True, ncol=ncol, bbox_to_anchor =bbox_to_anchor, prop={'weight':'bold', 'size':10}, framealpha=framealpha, borderpad=borderpad)
	if grid:
		ax.grid(linewidth='1.5', linestyle='dashed')
	if xn != None:
		ax.set_xlabel(xn, fontweight='bold')
	if yn != None:
		ax.set_ylabel(yn, fontweight='bold')
	if title != None:
		ax.set_title(title, fontweight='bold')
	return ax

def SetScatterProp(ax, xn=None, yn=None, title=None, legend = True, Loc = 'upper right'):
	fontsize = 14
	for axis in ['top','bottom','left','right']:
		ax.spines[axis].set_linewidth(2.5)

	ax.set_yticklabels([])
	ax.set_xticklabels([])

	if legend:   
		ax.legend(loc=Loc, shadow=True, prop={'weight':'bold'})

	if title != None:
		ax.set_title(title, fontweight='bold')
	return ax

def DrawData(Args, data, BER):
	"""
	Args: parser(). Parameter options
	data: array. Dataset
	BER: Bayes error rate
	"""
	print('Drawing synthetic dataset...')
	Path = os.getcwd() + '/Figures/%s/Data/'%Args.DataType
	if not os.path.exists(Path):
		os.makedirs(Path)
	Fig = plt.figure(); ax = Fig.gca()

	Feat = data[:, :-1]
	Label = data[:, -1]
		
	ax.scatter(Feat[Label == 0, 0], Feat[Label == 0, 1], c = 'r', label = 'Class 0', s = 30)
	ax.scatter(Feat[Label == 1, 0], Feat[Label == 1, 1], c = 'b', label = 'Class 1', s = 30)
	plt.axis(aspect='equal')
	ax = SetScatterProp(ax, legend = True, Loc = 'upper left')
	ax.set_aspect(aspect='equal')
	Fig.savefig(Path + 'SynSep%.2fDel%.2fSize%d.png'%(Args.Sep, Args.Del, Args.S), bbox_inches='tight')
	plt.close('all')


def DrawQueriedLabels(Args):
	from Dataset import GetData 
	print('Drawing labelled data generated by active learning...')
	Sep = [0.2, 0.4, 0.6, 0.8, 1]
	QueryMethod = ['Passive',  'UpdateTrain_EnhanceUncertainty2'];
	
	QueryType = ['Passive', 'Bimodal(Update)']

	TestType = ['SequentialPT', 'SequentialPT'];

	TestLabel = ['Lhéritier-MLE', 'Lhéritier-MLE'];

	MethodLabel = ['Passive', 'Bimodal(Update)']
	Debias = [2, 2]


	for sep in Sep:
		Args.Sep = sep; 
		TrData, HoldoutData = GetData(Args)
		for T1, T2, d, q, ql, m in zip(TestType, TestLabel, Debias, QueryMethod, QueryType, MethodLabel):
			QueryPath = os.getcwd() + '/Stats/%s/%s/Prior%.1f/D%dSep%.2fDel%.2fSize%d/Query/'%(Args.DataType, 
						Args.cls, Args.prior,Args.FeatLen, Args.Sep, Args.Del, Args.S)

			QueryPath = QueryPath + 'unbias%d/%s/QueryClsSize%d/'%(d, q, Args.InitSize)
			FigurePath = os.getcwd() + '/Figures/%s/%s/Prior%.1f/Alpha%.2f/'%(Args.DataType, 
				         Args.cls, Args.prior, Args.alpha)
			FigurePath = FigurePath+ 'QueryVis/D%dSep%.2fDel%.2fSize%d/QueryClassifierSize%d/TwoSampleClsSize%d/unbias%s/%s/'%(Args.FeatLen, Args.Sep, Args.Del, Args.S, 
						 Args.InitSize, Args.SeqStartPoint, d, ql)

			with open(QueryPath + 'QueryIndex%d.txt'%Args.Trial, 'rb') as fp: QueryIndex = pickle.load(fp)
			with open(QueryPath + 'DiscardforTrainInd%d.txt'%Args.Trial, 'rb') as fp: DiscardforTrainInd = pickle.load(fp)
			with open(QueryPath + 'TestingInd%d.txt'%Args.Trial, 'rb') as fp: TestingInd = pickle.load(fp)

			if not os.path.exists(FigurePath):
				os.makedirs(FigurePath)

			Per = np.arange(0.1, Args.Per + Args.Interval, Args.Interval)
			d = TrData; q = QueryIndex; qd = DiscardforTrainInd; qt = TestingInd
			for p in Per:
				Fig = plt.figure()
				ax = plt.gca()
				QS = int(p * Args.S)
				if p != 1:
					ax.scatter(TrData[TrData[:, -1] == 0, 0], TrData[TrData[:, -1] == 0, 1], c= 'r', label = 'Class 0',s = 30)
					ax.scatter(TrData[TrData[:, -1] == 1, 0], TrData[TrData[:, -1] == 1, 1], c = 'b', label = 'Class 1', s = 30)
				QS = min(len(q), QS)
				pq = np.uint16(q[:QS]); 
				pqd = []; pqt = []
				
				for ind in pq:
					if ind in qd:
						pqd.append(ind)
					elif ind in qt:
						pqt.append(ind)
				QueryD = TrData[np.uint16(q[:QS])];
				
				# ax.scatter(QueryD[QueryD[:, -1] == 0, 0], QueryD[QueryD[:, -1] == 0, 1], c= 'r', label = 'Class 0(Queried)', s = 30)
				# ax.scatter(QueryD[QueryD[:, -1] == 1, 0], QueryD[QueryD[:, -1] == 1, 1], c = 'b', label = 'Class 1(Queried)', s = 30)
				# ax.scatter(d[pq, 0], d[pq, 1], c = 'g', label = 'Queried', s = 30)
				
				ax.scatter(TrData[pqd, 0], TrData[pqd, 1], c = 'c', label = 'Discarded', s = 30)
				ax.scatter(TrData[pqt, 0], TrData[pqt, 1], c = 'g', label = 'Testing', s = 30)

				ax = SetScatterProp(ax, Loc = 'upper left', legend = True)
				ax.set_aspect(aspect='equal')
				Fig.savefig(FigurePath + '%sPer%.2fQueriedLabel%d.png'%(m, p, Args.Trial), bbox_inches='tight')
				plt.close('all')
				# pdb.set_trace()
				if QS == len(q):
					break


def GetDirectory(Args):

	if Args.DataType == 'Syn':
		StatsPath = os.getcwd() + '/Stats/%s/%s/Prior%.1f/D%dSep%.2fDel%.2fSize%d/Alpha%.2f/'%(Args.DataType, Args.cls, Args.prior, Args.FeatLen, Args.Sep, Args.Del, Args.S, Args.alpha)
		QueryPath = os.getcwd() + '/Stats/%s/%s/Prior%.1f/D%dSep%.2fDel%.2fSize%d/Query/'%(Args.DataType, Args.cls,Args.prior,Args.FeatLen, Args.Sep, Args.Del, Args.S)
		FigurePath = os.getcwd() + '/Figures/%s/%s/Prior%.1f/D%dSep%.2fDel%.2fSize%d/Alpha%.2f/'%(Args.DataType, Args.cls,Args.prior,Args.FeatLen, Args.Sep, Args.Del, Args.S, Args.alpha)
		QueryFigurePath = os.getcwd() + '/Figures/%s/%s/Prior%.1f/D%dSep%.2fDel%.2fSize%d/Query/'%(Args.DataType, Args.cls,Args.prior,Args.FeatLen, Args.Sep, Args.Del, Args.S)
	else:
		if Args.cls == 'CaliKnn' or Args.cls == 'PCAKnn':
			StatsPath = os.getcwd() + '/Stats/%s/%s(%.1f)/Prior%.1f/Alpha%.2f/'%(Args.DataType, Args.cls, Args.gr, Args.prior, Args.alpha)
			QueryPath = os.getcwd() + '/Stats/%s/%s(%.1f)/Prior%.1f/Query/'%(Args.DataType, Args.cls, Args.gr, Args.prior)
			FigurePath = os.getcwd() + '/Figures/%s/%s(%.1f)/Prior%.1f/Alpha%.2f/'%(Args.DataType, Args.cls, Args.gr, Args.prior, Args.alpha)
			QueryFigurePath = os.getcwd() + '/Figures/%s/%s(%.1f)/Prior%.1f/Query/'%(Args.DataType,Args.cls, Args.gr, Args.prior)
		else:
			StatsPath = os.getcwd() + '/Stats/%s/%s/Prior%.1f/Alpha%.2f/'%(Args.DataType, Args.cls,Args.prior, Args.alpha)
			QueryPath = os.getcwd() + '/Stats/%s/%s/Prior%.1f/Query/'%(Args.DataType, Args.cls,Args.prior)
			FigurePath = os.getcwd() + '/Figures/%s/%s/Prior%.1f/Alpha%.2f/'%(Args.DataType, Args.cls,Args.prior, Args.alpha)
			QueryFigurePath = os.getcwd() + '/Figures/%s/%s/Prior%.1f/Query/'%(Args.DataType,Args.cls, Args.prior)
	return StatsPath, FigurePath, QueryPath, QueryFigurePath

def PlotStatsDistri2(args, StatsPath):
	"""
	For permutation distribution generation
	Args: input argument 
	StatsPath: str. Path to the stats directory  
	StatsName: str. Name of stats
	"""
	stats=np.load(StatsPath + 'StatsTrial%d.npy'%(args.Trial))
	
	PValOrStopPoint = stats[0]; Reject=stats[1]; 
	PerTestN =stats[2]; PerDiscardforTrain =stats[3] 
	PerDiscardforFair = stats[4]; PerMI = stats[5];
	PerStats = stats[6]  

	# np.save(StatsPath + 'Reject%d.npy'%args.Trial, Reject);np.save(StatsPath + 'PValOrStopPoint%d.npy'%args.Trial, PValOrStopPoint)
	if args.WriteToExcel == 1:
		if args.qs[:8] == 'V3Update':
			PerSwitch = stats[7];PerBrierScore = stats[8]; 
			WriteToExcel2(args, StatsPath, 'Stats', Reject, PValOrStopPoint, PerTestN, PerDiscardforTrain, PerDiscardforFair, PerMI, PerStats, PerSwitch, PerBrierScore, args.Trial)
		else: 
			WriteToExcel1(args, StatsPath, 'Stats', Reject, PValOrStopPoint, PerTestN, PerDiscardforTrain, PerDiscardforFair, PerMI, PerStats, args.Trial)

	
def PlotUnfairPriorLETypeI(args):
	FigurePath = os.getcwd() + '/Figures/%s/%s/Prior%.1f/Alpha%.2f/'%(args.DataType, args.cls, args.prior, args.alpha)
	FigurePath1= FigurePath + 'TypeI/Debias/QueryClassifierSize%d/TwoSampleClsSize%d/Err/'%(args.InitSize, args.SeqStartPoint)


	QueryMethod = ['V12UpdateTrain_EnhanceUncertainty2', 'V9UpdateTrain_EnhanceUncertainty2'];
	
	QueryType = ['V12UpdateBimodal', 'V9UpdateBimodal']

	TestType = ['SequentialPT', 'SequentialPT'];

	TestLabel = ['Lhéritier-MLE', 'Lhéritier-MLE'];

	MethodLabel = ['Proposed1', 'Proposed2']

	Debias = [2,2]

	if not os.path.exists(FigurePath1):
		os.makedirs(FigurePath1)

	SampleSize = np.arange(args.Interval, args.Per + args.Interval, args.Interval) * args.S; 
	Color = ['b', 'g', 'c', 'm', 'y', 'lightcoral', 'teal'];  
	Sep = [0]; Alphabet = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K']
	
	for j in range(len(Sep)):
		Fig1 = plt.figure(); ax1= Fig1.gca(); CurveCount = 0; 
		for t, tl, q, ql, d, m in zip(TestType, TestLabel, QueryMethod, QueryType, Debias, MethodLabel):
			
			if args.DataType=='Syn':
				StatsPath = os.getcwd() + '/Stats/%s/%s/Prior%.1f/D%dSep%.2fDel%.2fSize%d/Alpha%.2f/'%(args.DataType, args.cls, args.prior, args.FeatLen, Sep[j], args.Del, args.S, args.alpha)
				if q=='Passive' or q[:6] == 'Update':
					DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/TwoSampleClsSize%d/'%(d, q, t, args.SeqStartPoint)
				else:
					DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/QueryClassifierSize%d/TwoSampleClsSize%d/'%(d, q, t, args.InitSize, args.SeqStartPoint)			
			else:
				StatsPath = os.getcwd() + '/Stats/%s/%s/Prior%.1f/Alpha%.2f/'%(args.DataType, args.cls, args.prior, args.alpha)				
				DebiasStatsPath = StatsPath + 'unbias2/%s/%s/QueryClassifierSize%d/TwoSampleClsSize%d/'%(q, t, args.InitSize, args.SeqStartPoint)		
			Trial = args.Trial; NAcase = 0
			print('Prior:%.2f, Classifier:%s, Sep:%.2f, Query method: %s'%(args.prior, args.cls, Sep[j], m))


			# Debiaswb=load_workbook(DebiasStatsPath + 'Stats.xlsx', data_only=True);
			# Debiasws1=Debiaswb['Reject']; Debiasws2=Debiaswb['PVal'];
			DebiasReject = np.zeros(len(SampleSize)); DebiasStop = np.zeros(len(SampleSize)); 
			Upp_CI = np.zeros(len(SampleSize)); Low_CI = np.zeros(len(SampleSize))

			# for i in range(len(SampleSize)):
			for u in range(args.Trial):
				if exists(DebiasStatsPath + 'StatsTrial%d.npy'%(u+ 1)):
					Stats = np.load(DebiasStatsPath + 'StatsTrial%d.npy'%(u + 1));
					DebiasReject+= Stats[1]
					DebiasStop+= Stats[0]
				else:
					args.Trial = u;break

					# if Reject[i]==None:
					# 	# Trial-=1;
					# 	# DebiasReject[i]+=0 
					# 	print(u)
					# 	# pdb.set_trace()
					# 	NAcase+=1
					# else:
					# 	# DebiasReject[i]+= Debiasws1['%s%d'%(Alphabet[i], u + 1)].value
					# 	DebiasReject[i]+=Reject[i]
			print('%d Trial'%args.Trial)
			for i in range(len(SampleSize)):
				Low_CI[i], Upp_CI[i] = proportion_confint(DebiasReject[i], Trial, alpha = args.alpha, method='normal')

			DebiasReject = DebiasReject/args.Trial; 
			print(DebiasReject[:5])
			ax1.plot(SampleSize, DebiasReject, '-', marker = 'o', c=Color[CurveCount], markersize = 8, label=m, linewidth = 3); 
			# ax1.errorbar(SampleSize, DebiasReject, yerr=[DebiasReject - Low_CI, Upp_CI- DebiasReject], color=Color[CurveCount], linewidth = 4, capsize=8, linestyle="None",
	  #            		marker="o", markersize=8, mfc=Color[CurveCount], mec=Color[CurveCount])						
			CurveCount+=1
	plt.ylim([0,0.2]); 
	plt.yticks([0.00, 0.05, 0.10, 0.15, 0.20])
	ax1.plot(SampleSize, np.ones(len(SampleSize)) * args.alpha, c = 'r', markersize = 8, linewidth = 4, label = r"$\alpha$"+"=%.2f"%args.alpha)
	ax1 = SetPltProp(ax1, xn='Label budget', yn='Type I', pos='upper right')
	ax2 = SetPltProp(ax1, xn='Sample size', yn='Type II', pos='upper right')

	Fig1.savefig(FigurePath1 + 'SeqTestingSep%.2fTypeI.png'%(Sep[j]), bbox_inches='tight')
	plt.close('all')


def PlotUnfairSWResultsComp(args):
	# Set up paths
	FigurePath = os.getcwd() + '/Figures/%s/SWComp/%s/Prior%.1f/Alpha%.2f/'%(args.DataType, args.cls, args.prior, args.alpha)
	FigurePath = FigurePath+ 'TypeII/Debias/QueryClassifierSize%d/TwoSampleClsSize%d/Err_Stop/'%(args.InitSize, args.SeqStartPoint)
	Per = np.arange(args.Interval, args.Per + args.Interval, args.Interval); 
	Alphabet = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K']

	if not os.path.exists(FigurePath):
		os.makedirs(FigurePath)


	if args.DataType == 'Syn':
		# Sep = [0.2, 0.4, 0.6, 0.8, 1]
		Sep = [0.4, 0.6, 0.8, 1]
		# Sep = [0.4]

	else:
		Sep = [args.DataType]

	# QueryMethod = ['Passive', 'UAIUpdateTrain_EnhanceUncertainty2', 'V12UpdateTrain_EnhanceUncertainty2',
	#				 'UpdateTrain_EnhanceUncertainty2', 'V13UpdateTrain_EnhanceUncertainty2', 'V9UpdateTrain_EnhanceUncertainty2']
	QueryMethod = ['Passive', 'V10UpdateTrain_EnhanceUncertainty2',]

	TestType = ['SequentialPT','SequentialPT'];

	TestLabel = ['Lhéritier-MLE','Lhéritier-MLE'];

	MethodLabel = ['Uniform query','Proposed']
	Debias = [2, 2,2, 2, 2, 2]


	SampleSize = np.arange(args.Interval, args.Per + args.Interval, args.Interval) * args.S; 
	# Color = ['g', 'b', 'r', 'c', 'm', 'y', 'lightcoral', 'teal'];  
	Color = ['r', 'b', 'c', 'm', 'y', 'lightcoral', 'teal']; 
	for j in range(len(Sep)):
		Fig1 = plt.figure(); ax1= Fig1.gca();
		Fig2 = plt.figure(); ax2= Fig2.gca();
		Cnum = 0
		for T1, T2, d, q, m in zip(TestType, TestLabel, Debias, QueryMethod, MethodLabel):
			# for q, ql in zip(QueryMethod, QueryType):
			Err = np.zeros(len(Per)); Stop = np.zeros((len(Per)))

			if args.cls != 'logistic':
				if Cnum == 3:
					break
			if args.DataType == 'Syn':
				# print('Prior:%.2f, Sep: %.2f, Query strategy: %s, Test Type:%s, Sequential testing starting point:%d'%(args.prior, Sep[j], q, T2, args.SeqStartPoint))
				StatsPath = os.getcwd() + '/Stats/%s/%s/Prior%.1f/D%dSep%.2fDel%.2fSize%d/Alpha%.2f/'%(args.DataType, args.cls, args.prior, args.FeatLen, Sep[j], args.Del, args.S, args.alpha)
				if q=='Passive' or q[:6] == 'Update':
					DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/TwoSampleClsSize%d/'%(d, q, T1, args.SeqStartPoint)
				# elif q[:8] == 'V7Update':
				# 	DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/QueryClassifierSize%d/TwoSampleClsSize%d/'%(d, q, T1, args.KFold, args.SeqStartPoint)
				else:
					DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/QueryClassifierSize%d/TwoSampleClsSize%d/'%(d, q, T1, args.InitSize, args.SeqStartPoint)
			else:
				# print('Prior:%.2f, Data Type: %s, Query strategy: %s, Test Type:%s, Sequential testing starting point:%d'%(args.prior, args.DataType, q, T2, args.SeqStartPoint))
				if args.cls == 'CaliKnn' or args.cls == 'PCAKnn':
					StatsPath = os.getcwd() + '/Stats/%s/%s(%.1f)/Prior%.1f/Alpha%.2f/'%(args.DataType,  args.cls, args.gr, args.prior, args.alpha)
				else:
					StatsPath = os.getcwd() + '/Stats/%s/%s/Prior%.1f/Alpha%.2f/'%(args.DataType,  args.cls, args.prior, args.alpha)
				if q=='Passive' or q[:6] == 'Update':
					DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/TwoSampleClsSize%d/'%(d, q, T1, args.SeqStartPoint)

				else:
					DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/QueryClassifierSize%d/TwoSampleClsSize%d/'%(d, q, T1, args.InitSize, args.SeqStartPoint)
			
			# Debiaswb=load_workbook(DebiasStatsPath + 'Stats.xlsx', data_only=True);
			# Debiasws1=Debiaswb['Reject']; Debiasws2=Debiaswb['PVal'];
			DebiasReject = np.zeros(len(Per)); DebiasStop = np.zeros(len(Per)); 

			
			for t in range(args.Trial):
				if exists(DebiasStatsPath + 'StatsTrial%d.npy'%(t + 1)):
					Stats = np.load(DebiasStatsPath + 'StatsTrial%d.npy'%(t + 1));
					DebiasReject+= Stats[1]
					DebiasStop+= Stats[0]
					# AllDebiasStop[t] = Stats[0]
				else:
					args.Trial = t;break
	
			for i in range(len(Per)):
				Err[i] = (args.Trial - DebiasReject[i])/args.Trial; 
				Stop[i] = DebiasStop[i]/args.Trial
			ErrSortInd = np.argsort(Err)

			if Sep[j] == 'ADNI':
				ax1.plot(SampleSize[1:], Stop[1:], '-', marker = 'o', c=Color[Cnum], markersize = 8, label=m, linewidth = 3); 
				ax2.plot(SampleSize[1:], Err[1:], '-', marker = 'o', c=Color[Cnum], markersize = 8, label=m, linewidth = 3); 
				print('Method:%s, Classifier:%s, Prior:%.2f,  Sep:%s, Stop:%s, Err:%s'%(m, args.cls, args.prior, Sep[j], Stop[1:6], Err[1:6]))
			else:
				ax1.plot(SampleSize, Stop, '-', marker = 'o', c=Color[Cnum], markersize = 8, label=m, linewidth = 3); 
				ax2.plot(SampleSize, Err, '-', marker = 'o', c=Color[Cnum], markersize = 8, label=m, linewidth = 3); 
				print('Method:%s, Classifier:%s, Prior:%.2f,  Sep:%s, Stop:%s, Err:%s'%(m, args.cls, args.prior, Sep[j], Stop[:5], Err[:5]))
			Cnum+=1
			# print('Method:%s, Classifier:%s, Prior:%.2f,  Sep:%s, Stop:%s, Err:%s'%(m, args.cls, args.prior, Sep[j]/2, Stop, Err))
			# print('%d trials verified'%args.Trial)
		ax1 = SetPltProp(ax1, xn='Label budget', yn='Stopping time', pos='best')
		ax2 = SetPltProp(ax2, xn='Label budget', yn='Type II', pos='best')
		if args.DataType == 'Syn':
			Fig1.savefig(FigurePath + 'Sep%.1fStop.png'%(Sep[j]), pos='best')
			Fig2.savefig(FigurePath + 'Sep%.1fTypeII.png'%(Sep[j]), pos='best')
		else:
			Fig1.savefig(FigurePath + '%sStop.png'%(args.DataType), pos='best')
			Fig2.savefig(FigurePath + '%sTypeII.png'%(args.DataType), pos='best')			
		plt.close('all')

def PlotUnfairClsSeqResultsComp(args):
	# Set up paths
	FigurePath = os.getcwd() + '/Figures/%s/ClsComp/Prior%.1f/Alpha%.2f/'%(args.DataType, args.prior, args.alpha)
	FigurePath = FigurePath+ 'TypeII/Debias/QueryClassifierSize%d/TwoSampleClsSize%d/Err_Stop/'%(args.InitSize, args.SeqStartPoint)
	Per = np.arange(args.Interval, args.Per + args.Interval, args.Interval); 
	Alphabet = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K']

	if not os.path.exists(FigurePath):
		os.makedirs(FigurePath)


	if args.DataType == 'Syn':
		Sep = [0.2, 0.4, 0.6, 0.8, 1]
	elif args.DataType == 'MNIST':
		Sep = ['MNIST']
	elif args.DataType == 'ADNI':
		Sep = ['ADNI']
   

	QueryMethod = ['UpdateTrain_EnhanceUncertainty2', 'UpdateTrain_EnhanceUncertainty2'];
	
	QueryType = ['UpdateBimodal', 'OneTimeBimodal']

	TestType = [ 'SequentialPT', 'SequentialPT'];

	TestLabel = ['Lhéritier-MLE','Lhéritier-MLE'];

	MethodLabel = ['Update-Bimodal(logistic)', 'Update-Bimodal(knn)']
	CLS = ['logistic','knn']
	Debias = [2, 2]


	SampleSize = np.arange(args.Interval, args.Per + args.Interval, args.Interval) * args.S; 
	# Color = ['g', 'b', 'r', 'c', 'm', 'y', 'lightcoral', 'teal'];  
	Color = ['r', 'b', 'r', 'c', 'm', 'y', 'lightcoral', 'teal'];
	for j in range(len(Sep)):
		Fig1 = plt.figure(); ax1= Fig1.gca();
		Fig2 = plt.figure(); ax2= Fig2.gca();
		Cnum = 0
		for T1, T2, d, q, ql, m, cl in zip(TestType, TestLabel, Debias, QueryMethod, QueryType, MethodLabel, CLS):

			# for q, ql in zip(QueryMethod, QueryType):
			Err = np.zeros(len(Per)); Stop = np.zeros((len(Per)))
			if args.DataType == 'Syn':
				print('Prior:%.2f, Sep: %.2f, Query strategy: %s, Test Type:%s, Sequential testing starting point:%d'%(args.prior, Sep[j], q, T2, args.SeqStartPoint))
				StatsPath = os.getcwd() + '/Stats/%s/%s/Prior%.1f/D%dSep%.2fDel%.2fSize%d/Alpha%.2f/'%(args.DataType, cl, args.prior, args.FeatLen, Sep[j], args.Del, args.S, args.alpha)
				if q=='Passive' or q[:6] == 'Update':
					DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/TwoSampleClsSize%d/'%(d, q, T1, args.SeqStartPoint)
				else:
					DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/QueryClassifierSize%d/TwoSampleClsSize%d/'%(d, q, T1, args.InitSize, args.SeqStartPoint)
			else:
				print('Prior:%.2f, Data Type: %s, Query strategy: %s, Test Type:%s, Debias strategy: %d, Sequential testing starting point:%d'%(args.prior, args.DataType, q, T, d, args.SeqStartPoint))
				StatsPath = os.getcwd() + '/Stats/%s/Prior%.1f/Alpha%.2f/'%(args.DataType, args.prior, args.alpha)
				if q=='Passive' or q[:6] == 'Update':
					DebiasStatsPath = StatsPath + '%s/unbias%d/%s/%s/TwoSampleClsSize%d/'%(args.cls, d, q, T1, args.SeqStartPoint)
				else:
					DebiasStatsPath = StatsPath + '%s/unbias%d/%s/%s/QueryClassifierSize(TwoSampleClsSize)%d/'%(args.cls, d, q, T1, args.InitSize)
			
			DebiasReject = np.zeros(len(Per)); DebiasStop = np.zeros(len(Per)); 

			for t in range(args.Trial):
				print(t)
				Stats = np.load(DebiasStatsPath + 'StatsTrial%d.npy'%(t + 1));
				DebiasReject+= Stats[1]
				DebiasStop+= Stats[0]
	
			for i in range(len(Per)):
				Err[i] = (args.Trial - DebiasReject[i])/args.Trial; 
				Stop[i] = DebiasStop[i]/args.Trial
			ErrSortInd = np.argsort(Err)

			ax1.plot(SampleSize, Stop, '-', marker = 'o', c=Color[Cnum], markersize = 8, label=m, linewidth = 3); 
			ax2.plot(SampleSize, Err, '-', marker = 'o', c=Color[Cnum], markersize = 8, label=m, linewidth = 3); 
			Cnum+=1


		ax1 = SetPltProp(ax1, xn='Label budget', yn='Stop time', pos='best')
		ax2 = SetPltProp(ax2, xn='Label budget', yn='Type II', pos='best')
		Fig1.savefig(FigurePath + 'Sep%.1fStop.png'%(Sep[j]), pos='best')
		Fig2.savefig(FigurePath + 'Sep%.1fTypeII.png'%(Sep[j]), pos='best')
		plt.close('all')

def PlotUnfairSeqStatsComp(args):
	# Set up paths
	FigurePath = os.getcwd() + '/Figures/%s/%s/Prior%.1f/Alpha%.2f/'%(args.DataType, args.cls, args.prior, args.alpha)
	FigurePath = FigurePath+ 'SeqStats/Debias/QueryClassifierSize%d/TwoSampleClsSize%d/'%(args.InitSize, args.SeqStartPoint)
	Per = np.arange(args.Interval, args.Per + args.Interval, args.Interval);
	LabelBudget = args.S * Per;
	Alphabet = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K']

	if not os.path.exists(FigurePath):
		os.makedirs(FigurePath)

	if args.DataType == 'Syn':
		Sep = [0.2, 0.4, 0.6, 0.8, 1]
	elif args.DataType == 'MNIST':
		Sep = ['MNIST']
	elif args.DataType == 'ADNI':
		Sep = ['ADNI']
   

	QueryMethod = ['Passive',
				   'OneTimeTrain_EnhanceUncertainty2',
				   'UpdateTrain_EnhanceUncertainty2',
					'V3UpdateTrain_EnhanceUncertainty2'];

	TestType = ['SequentialPT', 'SequentialPT', 
	            'SequentialPT', 'SequentialPT'];

	TestLabel = ['Lhéritier-MLE', 'Lhéritier-MLE', 
	             'Lhéritier-MLE', 'Lhéritier-MLE'];

	MethodLabel = ['Passive', 'NoUpdate-Bimodal', 'Update-Bimodal', 
	               'CV-Update-Bimodal']
	Debias = [2, 2, 2, 2]


	SampleSize = np.arange(args.Interval, args.Per + args.Interval, args.Interval) * args.S; 
	Color = ['g', 'b', 'r', 'c', 'm', 'y', 'lightcoral', 'teal'];  
	for j in range(len(Sep)):
		for T1, T2, d, q, m in zip(TestType, TestLabel, Debias, QueryMethod, MethodLabel):
			Fig = plt.figure(); ax= Fig.gca(); # The resulting mutual information
			RealStats = np.zeros(len(Per)); 
			RealStatsAllTrials = np.zeros((args.Trial, len(Per)));
			ThsAllTrials = np.zeros((args.Trial, len(Per)));
			RealStatsStdBar =  np.zeros((2, len(Per)));
			ThsStdBar =  np.zeros((2, len(Per)));
			if args.DataType == 'Syn':
				print('Prior:%.2f, Sep: %.2f, Query strategy: %s, Test Type:%s, Sequential testing starting point:%d'%(args.prior, Sep[j], q, T2, args.SeqStartPoint))
				StatsPath = os.getcwd() + '/Stats/%s/%s/Prior%.1f/D%dSep%.2fDel%.2fSize%d/Alpha%.2f/'%(args.DataType, args.cls, args.prior, args.FeatLen, Sep[j], args.Del, args.S, args.alpha)
				if q=='Passive' or q[:6] == 'Update':
					DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/TwoSampleClsSize%d/'%(d, q, T1, args.SeqStartPoint)
				else:
					DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/QueryClassifierSize%d/TwoSampleClsSize%d/'%(d, q, T1, args.InitSize, args.SeqStartPoint)
			else:
				print('Prior:%.2f, Data Type: %s, Query strategy: %s, Test Type:%s, Debias strategy: %d, Sequential testing starting point:%d'%(args.prior, args.DataType, q, T, d, args.SeqStartPoint))
				StatsPath = os.getcwd() + '/Stats/%s/Prior%.1f/Alpha%.2f/'%(args.DataType, args.prior, args.alpha)
				if q=='Passive' or q[:6] == 'Update':
					DebiasStatsPath = StatsPath + '%s/unbias%d/%s/%s/TwoSampleClsSize%d/'%(args.cls, d, q, T1, args.SeqStartPoint)
				else:
					DebiasStatsPath = StatsPath + '%s/unbias%d/%s/%s/QueryClassifierSize(TwoSampleClsSize)%d/'%(args.cls, d, q, T1, args.InitSize)
						
			for t in range(args.Trial):
				print(t); StatsTrial = np.load(DebiasStatsPath + 'StatsTrial%d.npy'%(t+1));
				RealStats+= StatsTrial[6, :]; 
				RealStatsAllTrials[t] = StatsTrial[6, :]
				ThsAllTrials[t] = StatsTrial[2, :]

			AvgStats = RealStats / args.Trial
			ThsAllTrials = -np.log2(args.alpha)/ThsAllTrials;
			AvgThs = np.mean(ThsAllTrials, 0); Thsstd = np.std(ThsAllTrials);
			Statstd = np.std(RealStatsAllTrials)
			ThsStdBar[0] = AvgThs - Thsstd; ThsStdBar[1] = AvgThs + Thsstd; 
			RealStatsStdBar[0] = AvgStats - Statstd; RealStatsStdBar[1] = AvgStats + Statstd 

			ax.plot(LabelBudget, AvgStats,  linestyle="-", marker = 'o', c='r', markersize = 8, label=m, linewidth = 3);
			ax.fill_between(LabelBudget, RealStatsStdBar[0], RealStatsStdBar[1], color='r', alpha = 0.3);

			ax.plot(LabelBudget, AvgThs,  linestyle="-", marker = 'o', c='b', markersize = 8, label=r"$\alpha$(Scaled)", linewidth = 3);
			ax.fill_between(LabelBudget, ThsStdBar[0], ThsStdBar[1], color='b', alpha = 0.3);

			ax = SetPltProp(ax, xn='Label budget', yn='Statistics', pos='best')
			Fig.savefig(FigurePath + 'Sep%.1f%sStopTimeStats.png'%(Sep[j], m), pos='best')
			plt.close('all')
def PlotClsProb(args):
	print('Plotting classification score...')
	# Sep = [0.2, 0.4];
	Sep = [0.2, 0.4]
	QueryMethod = ['Passive',
				   'OneTimeTrain_EnhanceUncertainty2',
				   'UpdateTrain_EnhanceUncertainty2',
					'V3UpdateTrain_EnhanceUncertainty2'];

	TestType = ['SequentialPT', 'SequentialPT', 
	            'SequentialPT', 'SequentialPT'];

	TestLabel = ['Lhéritier-MLE', 'Lhéritier-MLE', 
	             'Lhéritier-MLE', 'Lhéritier-MLE'];

	MethodLabel = ['Passive', 'NoUpdate-Bimodal', 'Update-Bimodal', 
	               'CV-Update-Bimodal']
	Debias = [2, 2, 2, 2]
	Color = ['r', 'c', 'b', 'm', 'y', 'lightcoral', 'teal'];  
	SampleSize = np.arange(args.Interval, args.Per + args.Interval, args.Interval) * args.S; 

	for sep in Sep:
		args.Sep = sep; 
		Fig = plt.figure()
		ax = plt.gca()
		Cnum = 0
		for T1, T2, d, q, m in zip(TestType, TestLabel, Debias, QueryMethod, MethodLabel):
			QueryPath = os.getcwd() + '/Stats/%s/%s/Prior%.1f/D%dSep%.2fDel%.2fSize%d/Query/'%(args.DataType, 
						args.cls, args.prior,args.FeatLen, args.Sep, args.Del, args.S)

			QueryPath = QueryPath + 'unbias%d/%s/QueryClsSize%d/'%(d, q, args.InitSize)
			FigurePath = os.getcwd() + '/Figures/%s/%s/Prior%.1f/Alpha%.2f/'%(args.DataType, 
				         args.cls, args.prior, args.alpha)
			FigurePath = FigurePath+ 'ClsProb/debias/QueryClassifierSize%d/TwoSampleClsSize%d/'%(args.InitSize, args.SeqStartPoint)

			if not os.path.exists(FigurePath):
				os.makedirs(FigurePath)

			Per = np.arange(0.1, args.Per + args.Interval, args.Interval);
			
			Low_CI = np.zeros(len(Per)); Upp_CI = np.zeros(len(Per)); 
			ClsProbAllTrial = np.zeros((args.Trial, len(Per)))
			AvgClsProbAllTrial = np.zeros(len(Per))
			for t in range(1, args.Trial+1):
				with open(QueryPath + 'PerProb%d.txt'%t, 'rb') as fp: PerProb = pickle.load(fp)
				with open(QueryPath + 'TestingInd%d.txt'%t, 'rb') as fp: TestingInd = pickle.load(fp)
				with open(QueryPath + 'QueryIndex%d.txt'%t, 'rb') as fp: QueryIndex = pickle.load(fp)
				ClsProbPer = np.zeros(len(Per)); CountPer = np.zeros(len(Per));
				# if m == 'Update-Bimodal':
				# 	print(PerProb) # debug
				StartIdx = 0; EndIdx = 0 ;
				for i in range(len(Per)):
				
					if i == 0:
						EndIdx = int(Per[i] * args.S)
					else:
						StartIdx = EndIdx; EndIdx = int(Per[i] * args.S)
					# print(StartIdx,EndIdx)
					for j in range(StartIdx, EndIdx):
						if j >= len(QueryIndex): 
							break
						elif QueryIndex[j] in TestingInd:
							ClsProbPer[i]+=PerProb[j]; CountPer[i]+=1 
							# print(PerProb[j])

				for i in range(len(Per)):
					if CountPer[i] != 0:

						ClsProbAllTrial[t - 1, i]=ClsProbPer[i] / CountPer[i]
					else:
						ClsProbAllTrial[t - 1, i] = -1
				# if m == 'Update-Bimodal':
				# 	print(ClsProbAllTrial[t - 1])
				# 	pdb.set_trace()
			CountPer2 = np.zeros(len(Per))
			# print(ClsProbAllTrial)

			for t in range(args.Trial):
				for i in range(len(Per)):
					if ClsProbAllTrial[t, i] != -1:
						AvgClsProbAllTrial[i]+=ClsProbAllTrial[t, i]
						CountPer2[i]+=1

			AvgClsProbAllTrial= AvgClsProbAllTrial/CountPer2
			
			# for i in range(len(Per)):
			# 	Low_CI[i], Upp_CI[i] = norm.interval(alpha=0.95, loc=AvgClsProbAllTrial[i], scale=sem(ClsProbAllTrial[:, i]))
			
			ax.plot(SampleSize, AvgClsProbAllTrial, '-', marker = 'o', c=Color[Cnum], markersize = 8, label=m, linewidth = 3); 
			# ax.errorbar(SampleSize, AvgClsProbAllTrial, yerr=[AvgClsProbAllTrial - Low_CI, Upp_CI- AvgClsProbAllTrial], color=Color[Cnum], linewidth = 4, capsize=8, linestyle="None",
	  #            		marker="o", markersize=8, mfc=Color[Cnum], mec=Color[Cnum])	

			Cnum+=1
	
		ax = SetPltProp(ax, xn='Maximum sample size allowed', yn='Score', pos='upper right')
		Fig.savefig(FigurePath + '%.2fClsProb.png'%(sep), bbox_inches='tight')
		plt.close('all')


def PlotUnfairSeqResultsComp(args):
	# Set up paths
	FigurePath = os.getcwd() + '/Figures/%s/%s/Prior%.1f/Alpha%.2f/'%(args.DataType, args.cls, args.prior, args.alpha)
	FigurePath = FigurePath+ 'TypeII/Debias/QueryClassifierSize%d/TwoSampleClsSize%d/Err_Stop/'%(args.InitSize, args.SeqStartPoint)
	Per = np.arange(args.Interval, args.Per + args.Interval, args.Interval); 
	Alphabet = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K']

	if not os.path.exists(FigurePath):
		os.makedirs(FigurePath)


	if args.DataType == 'Syn':
		# Sep = [0.2, 0.4, 0.6, 0.8, 1]
		Sep = [0.2, 0.4]
	elif args.DataType == 'MNIST':
		Sep = ['MNIST']
	elif args.DataType == 'ADNI':
		Sep = ['ADNI']
   

	QueryMethod = ['Passive',
				   'UpdateTrain_EnhanceUncertainty', 
				   'UpdateTrain_EnhanceUncertainty2',
				   'V3UpdateTrain_EnhanceUncertainty2'];
	
	QueryType = ['Passive', 
	            'UpdateCertainty', 
	             'UpdateBimodal',
	             'V3UpdateBimodal']

	TestType = ['SequentialPT', 
	            'SequentialPT', 
	            'SequentialPT',
	            'SequentialPT'];

	TestLabel = ['Lhéritier-MLE', 
	             'Lhéritier-MLE', 
	             'Lhéritier-MLE',
	             'Lhéritier-MLE'];

	MethodLabel = ['Baseline', 
	               'Cetainty', 
	               'Bimodal',
	               'CV-Bimodal']
	Debias = [2, 2, 2, 2]


	SampleSize = np.arange(args.Interval, args.Per + args.Interval, args.Interval) * args.Budget; 
	Color = ['g', 'b', 'r', 'c', 'm', 'y', 'lightcoral', 'teal'];  
	for j in range(len(Sep)):
		Fig1 = plt.figure(); ax1= Fig1.gca();
		Fig2 = plt.figure(); ax2= Fig2.gca();
		Cnum = 0
		for T1, T2, d, q, ql, m in zip(TestType, TestLabel, Debias, QueryMethod, QueryType, MethodLabel):

			# for q, ql in zip(QueryMethod, QueryType):
			Err = np.zeros(len(Per)); Stop = np.zeros((len(Per)))
			if args.DataType == 'Syn':
				print('Prior:%.2f, Sep: %.2f, Query strategy: %s, Test Type:%s, Sequential testing starting point:%d'%(args.prior, Sep[j], q, T2, args.SeqStartPoint))
				StatsPath = os.getcwd() + '/Stats/%s/%s/Prior%.1f/D%dSep%.2fDel%.2fSize%d/Alpha%.2f/'%(args.DataType, args.cls, args.prior, args.FeatLen, Sep[j], args.Del, args.S, args.alpha)
				if q=='Passive' or q[:6] == 'Update':
					DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/TwoSampleClsSize%d/'%(d, q, T1, args.SeqStartPoint)
				else:
					DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/QueryClassifierSize%d/TwoSampleClsSize%d/'%(d, q, T1, args.InitSize, args.SeqStartPoint)
			else:
				print('Prior:%.2f, Data Type: %s, Query strategy: %s, Test Type:%s, Debias strategy: %d, Sequential testing starting point:%d'%(args.prior, args.DataType, q, T, d, args.SeqStartPoint))
				StatsPath = os.getcwd() + '/Stats/%s/Prior%.1f/Alpha%.2f/'%(args.DataType, args.prior, args.alpha)
				if q=='Passive' or q[:6] == 'Update':
					DebiasStatsPath = StatsPath + '%s/unbias%d/%s/%s/TwoSampleClsSize%d/'%(args.cls, d, q, T1, args.SeqStartPoint)
				else:
					DebiasStatsPath = StatsPath + '%s/unbias%d/%s/%s/QueryClassifierSize(TwoSampleClsSize)%d/'%(args.cls, d, q, T1, args.InitSize)
			
			DebiasReject = np.zeros(len(Per)); DebiasStop = np.zeros(len(Per)); 

			for t in range(args.Trial):
				print(t)
				Stats = np.load(DebiasStatsPath + 'StatsTrial%d.npy'%(t + 1));
				DebiasReject+= Stats[1]
				DebiasStop+= Stats[0]

			for i in range(len(Per)):
				Err[i] = (args.Trial - DebiasReject[i])/args.Trial; 
				Stop[i] = DebiasStop[i]/args.Trial
			ErrSortInd = np.argsort(Err)

			ax1.plot(SampleSize, Stop, '-', marker = 'o', c=Color[Cnum], markersize = 8, label=m, linewidth = 3); 
			ax2.plot(SampleSize, Err, '-', marker = 'o', c=Color[Cnum], markersize = 8, label=m, linewidth = 3); 
			Cnum+=1


		ax1 = SetPltProp(ax1, xn='Label budget', yn='Stop time', pos='best')
		ax2 = SetPltProp(ax2, xn='Label budget', yn='Type II', pos='best')
		Fig1.savefig(FigurePath + 'Size%dSep%.1fStop.png'%(args.S, Sep[j]), pos='best')
		Fig2.savefig(FigurePath + 'Size%dSep%.1fTypeII.png'%(args.S, Sep[j]), pos='best')
		plt.close('all')

def PlotFairPriorResultsSampleTrend(args):
	# Set up paths
	FigurePath = os.getcwd() + '/Figures/%s/SWComp/%s/Prior%.1f/Alpha%.2f/'%(args.DataType, args.cls, args.prior, args.alpha)
	FigurePath = FigurePath+ 'TypeII/Debias/QueryClassifierSize%d/TwoSampleClsSize%d/Err_Stop/'%(args.InitSize, args.SeqStartPoint)
	Per = np.arange(args.Interval, args.Per + args.Interval, args.Interval); 
	Alphabet = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K']

	if not os.path.exists(FigurePath):
		os.makedirs(FigurePath)


	Sep = [0.4, 0.6, 0.8, 1]

	# QueryMethod = ['Passive', 'UAIUpdateTrain_EnhanceUncertainty2', 'V12UpdateTrain_EnhanceUncertainty2',
	#				 'UpdateTrain_EnhanceUncertainty2', 'V13UpdateTrain_EnhanceUncertainty2', 'V9UpdateTrain_EnhanceUncertainty2']
	QueryMethod = ['Passive', 'V10UpdateTrain_EnhanceUncertainty2']

	TestType = ['SequentialPT','SequentialPT'];

	TestLabel = ['Lhéritier-MLE','Lhéritier-MLE'];

	MethodLabel = ['baseline (Lhéritier)','Proposed']
	Debias = [2, 2,2, 2, 2, 2]


	SampleSize = np.arange(args.Interval, args.Per + args.Interval, args.Interval) * args.S; 
	# Color = ['g', 'b', 'r', 'c', 'm', 'y', 'lightcoral', 'teal'];  
	Color = ['r', 'b', 'c', 'm', 'y', 'lightcoral', 'teal']; 

	for sizeind, Size in enumerate(SampleSize):
		Fig1 = plt.figure(); ax1= Fig1.gca();
		Fig2 = plt.figure(); ax2= Fig2.gca();	
		Cnum = 0
		for T1, T2, d, q, m in zip(TestType, TestLabel, Debias, QueryMethod, MethodLabel):
			Err = np.zeros(len(Sep)); Stop = np.zeros((len(Sep)))	
			ErrSum = np.zeros(len(Sep)); StopSum = np.zeros(len(Sep)); 
			for j in range(len(Sep)):
				if args.cls == 'knn' and m == 'QuerySwitch-Update-Bimodal':
					continue
				if args.DataType == 'Syn':
					# print('Prior:%.2f, Sep: %.2f, Query strategy: %s, Test Type:%s, Sequential testing starting point:%d'%(args.prior, Sep[j], q, T2, args.SeqStartPoint))
					StatsPath = os.getcwd() + '/Stats/%s/%s/Prior%.1f/D%dSep%.2fDel%.2fSize%d/Alpha%.2f/'%(args.DataType, args.cls, args.prior, args.FeatLen, Sep[j], args.Del, args.S, args.alpha)
					if q=='Passive' or q[:6] == 'Update':
						DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/TwoSampleClsSize%d/'%(d, q, T1, args.SeqStartPoint)
					# elif q[:8] == 'V7Update':
					# 	DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/QueryClassifierSize%d/TwoSampleClsSize%d/'%(d, q, T1, args.KFold, args.SeqStartPoint)
					else:
						DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/QueryClassifierSize%d/TwoSampleClsSize%d/'%(d, q, T1, args.InitSize, args.SeqStartPoint)
				else:
					# print('Prior:%.2f, Data Type: %s, Query strategy: %s, Test Type:%s, Sequential testing starting point:%d'%(args.prior, args.DataType, q, T2, args.SeqStartPoint))
					if args.cls == 'CaliKnn' or args.cls == 'PCAKnn':
						StatsPath = os.getcwd() + '/Stats/%s/%s(%.1f)/Prior%.1f/Alpha%.2f/'%(args.DataType,  args.cls, args.gr, args.prior, args.alpha)
					else:
						StatsPath = os.getcwd() + '/Stats/%s/%s/Prior%.1f/Alpha%.2f/'%(args.DataType,  args.cls, args.prior, args.alpha)
					if q=='Passive' or q[:6] == 'Update':
						DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/TwoSampleClsSize%d/'%(d, q, T1, args.SeqStartPoint)

					else:
						DebiasStatsPath = StatsPath + 'unbias%d/%s/%s/QueryClassifierSize%d/TwoSampleClsSize%d/'%(d, q, T1, args.InitSize, args.SeqStartPoint)
				
				# Debiaswb=load_workbook(DebiasStatsPath + 'Stats.xlsx', data_only=True);
				# Debiasws1=Debiaswb['Reject']; Debiasws2=Debiaswb['PVal'];
				

				
				for t in range(args.Trial):
					# if exists(DebiasStatsPath + 'StatsTrial%d.npy'%(t + 1)):
					Stats = np.load(DebiasStatsPath + 'StatsTrial%d.npy'%(t + 1));
					ErrSum[j]+= Stats[1][sizeind]
					StopSum[j]+= Stats[0][sizeind]
					# else:
					# 	args.Trial = t;break
	
			
				Err[j] = (args.Trial - ErrSum[j])/args.Trial; 
				Stop[j] = StopSum[j]/args.Trial
				ErrSortInd = np.argsort(Err)

			ax1.plot(np.array(Sep)/2, Stop, '-', marker = 'o', c=Color[Cnum], markersize = 8, label=m, linewidth = 3); 
			ax2.plot(np.array(Sep)/2, Err, '-', marker = 'o', c=Color[Cnum], markersize = 8, label=m, linewidth = 3); 
			Cnum+=1
			print('method:%s, label budget:%d, Type II error:%s, Stopping time:%s'%(m, Size, Err, Stop))
		# print('%d trials verified'%args.Trial)
		ax1 = SetPltProp(ax1, xn=r"$\delta$", yn='Stopping time', pos='best')
		ax2 = SetPltProp(ax2, xn=r"$\delta$", yn='Type II', pos='best')
		
		Fig1.savefig(FigurePath + 'Budget%dStop.png'%(Size), pos='best')
		Fig2.savefig(FigurePath + 'Budget%dTypeII.png'%(Size), pos='best')		
		plt.close('all')

def PlotAllStatsDistri(args, StatsPath):
	Path = StatsPath + 'FoundCutEdges(ClsUncertaintyQuery)/%s/%s/RunDistri/InitTrainingSize%d/'%(args.qs, args.cls, args.InitSize)
	Per = np.arange(args.Interval, args.Per + args.Interval, args.Interval); 
	if os.path.isfile(Path + 'ClsUncertaintyQuery.xlsx'):
		wb=load_workbook(Path + 'ClsUncertaintyQuery.xlsx');ws1=wb["Reject"];ws2=wb["PVal"];
	
	else:
		wb = Workbook(); ws1 = wb.create_sheet("Reject"); ws2 = wb.create_sheet("PVal"); 
	Alphabet = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J']

	for t in range(args.Trial):
		
		Reject = np.load(Path + 'Reject%d.npy'%(t + 1));
		PVal = np.load(Path + 'PVal%d.npy'%(t+1))
		
		for i in range(len(Per)):
			ws1.cell(row=t+1, column=i+1, value=Reject[i])
			ws2.cell(row=t+1, column=i+1, value=PVal[i])
			ws1['%s%d'%(Alphabet[i], args.Trial + 1)] ='=SUM(%s%d:%s%d)'%(Alphabet[i], 1, Alphabet[i], args.Trial)
			ws2['%s%d'%(Alphabet[i], args.Trial + 1)] ='=AVERAGE(%s%d:%s%d)'%(Alphabet[i], 1, Alphabet[i], args.Trial)	
	wb.save(Path + 'ClsUncertaintyQuery.xlsx')	






